#include "Header.h"
#include <ctime>

int a[100][100], bombs, difficulty, n;
bool game, win;

bool checkLimit(int, int);
void incrementare(int, int);
void generare();
void expand(int, int);
void checkwin();

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

HBITMAP background, logoImage;
HBITMAP hLogo;
HBITMAP button1, button2, button3;
HBITMAP buttonNewGame, emptyButton, bombButton;

HMENU gameMenu;

HWND buttonMatrix[25][25];
HWND button[3];
HWND logoButton;
HWND newGameButton;
HWND hWnd;
HWND credite;

void loadImages();
void createStart(HWND);
void addMenu(HWND);
void destroyEverything();
void playEasy(HWND);
void playMedium(HWND);
void playHard(HWND);
void updateGrid(HWND);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	WNDCLASSW wc = { 0 };
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hbrBackground = (HBRUSH)COLOR_WINDOW;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.lpszClassName = L"windowClass";
	wc.lpszMenuName = NULL;
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;

	if (!RegisterClassW(&wc))
	{
		MessageBoxW(NULL, L"Failed to create window.", NULL, MB_OK | MB_ICONERROR);
		return -1;
	}

	RECT desktopSize;
	const HWND hDesktop = GetDesktopWindow();
	GetWindowRect(hDesktop, &desktopSize);
	int widthCenter = (desktopSize.right - WINDOW_SIZE_WIDTH) / 2;
	int heightCenter = (desktopSize.bottom - WINDOW_SIZE_HEIGHT) / 2;

	hWnd = CreateWindowW(L"windowClass", L"Minesweeper", WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME ^ WS_MAXIMIZEBOX | WS_VISIBLE | WS_BORDER | SS_BITMAP,
		widthCenter, heightCenter, WINDOW_SIZE_WIDTH, WINDOW_SIZE_HEIGHT, NULL, NULL, hInstance, NULL);
	SendMessageW(hWnd, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)NULL);

	MSG msg = { 0 };

	while (GetMessage(&msg, NULL, NULL, NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	int xPos, yPos;
	switch (msg)
	{
	case WM_CREATE:
		loadImages();
		createStart(hwnd);
		addMenu(hwnd);
		break;
	case WM_COMMAND:
		if (wparam >= 10000 && wparam <= 12424)
		{
			int i, j;

			i = (int)wparam / 100 % 100;
			j = (int)wparam % 100;
			expand(i, j);
			checkwin();
			updateGrid(hwnd);
			if (game == 0)
            {
                if (win==0)
                {
                    MessageBox(NULL, "You lose!", "You lose!", MB_OK);
                    switch(difficulty)
                    {
                    case 1:
                        generare();
				destroyEverything();
                        playEasy(hwnd);
                        break;
                    case 2:
                        generare();
				destroyEverything();
                        playMedium(hwnd);
                        break;
                    case 3:
                        generare();
				destroyEverything();
                        playHard(hwnd);
                        break;
                    }
                }
                else
                {
                    MessageBox(NULL, "You win!", "You win!", MB_OK);
                    switch(difficulty)
                    {
                    case 1:
                        generare();
				destroyEverything();
                        playEasy(hwnd);
                        break;
                    case 2:
                        generare();
				destroyEverything();
                        playMedium(hwnd);
                        break;
                    case 3:
                        generare();
				destroyEverything();
                        playHard(hwnd);
                        break;
                }
            }
		}
		}
		else
		{
			switch (wparam)
			{
			case 1001:
				difficulty = 1;
				generare();
				destroyEverything();
				playEasy(hwnd);
				break;
			case 1002:
				difficulty = 2;
				generare();
				destroyEverything();
				playMedium(hwnd);
				break;
			case 1003:
				difficulty = 3;
				generare();
				destroyEverything();
				playHard(hwnd);
				break;
			case 1004:
				MessageBoxW(NULL, L"Vedeti documentatia din arhiva!", L"Ceva de ajutor", MB_OK);
				break;
			case 1009:
				DestroyWindow(hwnd);
				break;
			default:
				break;
			}
		}
		break;
	case WM_LBUTTONDBLCLK:
		xPos = GET_X_LPARAM(lparam);
		yPos = GET_Y_LPARAM(lparam);
		break;
	case WM_LBUTTONDOWN:
		xPos = GET_X_LPARAM(lparam);
		yPos = GET_Y_LPARAM(lparam);
		break;
	case WM_RBUTTONDOWN:
		xPos = GET_X_LPARAM(lparam);
		yPos = GET_Y_LPARAM(lparam);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		break;
	}
	return DefWindowProcW(hwnd, msg, wparam, lparam);
}

void loadImages()
{
	logoImage = (HBITMAP)LoadImageW(NULL, L"logo.bmp", IMAGE_BITMAP, 500, 500, LR_LOADFROMFILE);
	bombButton = (HBITMAP)LoadImageW(NULL, L"Bomb.bmp", IMAGE_BITMAP, 50, 50, LR_LOADFROMFILE);
}

void createStart(HWND hwnd)
{
    logoButton = CreateWindowW(L"Static", NULL, WS_VISIBLE | WS_CHILD | SS_BITMAP, 10, 10, 100, 50, hwnd, NULL, NULL, NULL);
	button[0] = CreateWindowW(L"Button", L"Joaca usor", WS_VISIBLE | WS_CHILD | SS_CENTER | WS_BORDER, 195, 150, 100, 30, hwnd, (HMENU)1001, NULL, NULL);
	button[1] = CreateWindowW(L"Button", L"Joaca mediu", WS_VISIBLE | WS_CHILD | SS_CENTER | WS_BORDER, 195, 200, 100, 30, hwnd, (HMENU)1002, NULL, NULL);
	button[2] = CreateWindowW(L"Button", L"Joaca greu", WS_VISIBLE | WS_CHILD | SS_CENTER | WS_BORDER, 195, 250, 100, 30, hwnd, (HMENU)1003, NULL, NULL);
	credite = CreateWindowW(L"Static", L"Creat de Level UP.Inc", WS_VISIBLE | WS_CHILD | SS_CENTER | WS_BORDER, 195, 500, 100, 50, hwnd, NULL, NULL, NULL);
	SendMessageW(logoButton, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)logoImage);
}

void addMenu(HWND hwnd)
{
	gameMenu = CreateMenu();

	HMENU Joc = CreateMenu();

	AppendMenuW(gameMenu, MF_POPUP, (UINT_PTR)Joc, L"Joc");
	AppendMenuW(Joc, MF_STRING, (UINT)1001, L"Usor");
	AppendMenuW(Joc, MF_STRING, (UINT)1002, L"Mediu");
	AppendMenuW(Joc, MF_STRING, (UINT)1003, L"Greu");
	AppendMenuW(Joc, MF_SEPARATOR, NULL, NULL);
	AppendMenuW(Joc, MF_STRING, (UINT)1009, L"Iesire");

	AppendMenu(gameMenu, MF_STRING, (UINT)1004, "Ajutor");

	SetMenu(hwnd, gameMenu);
}

void destroyEverything()
{
	int i, j;
	for (i = 0; i < 25; i++)
		for (j = 0; j < 25; j++)
			DestroyWindow(buttonMatrix[i][j]);
	for (i = 0; i < 3; i++)
	{
		DestroyWindow(button[i]);
	}
	DestroyWindow(logoButton);
	DestroyWindow(credite);
	DestroyWindow(newGameButton);
}

void playEasy(HWND hwnd)
{
	int i, j;
	int grila = 440;
	int nrbuttons = 8;
	newGameButton = CreateWindowW(L"Button", L"Joc nou", WS_VISIBLE | WS_CHILD, (WINDOW_SIZE_WIDTH - 60) / 2, 10, 60, 30, hwnd, (HMENU)1001, NULL, NULL);
	for (i = 1; i <= nrbuttons; i++)
		for (j = 1; j <= nrbuttons; j++)
		{
			int x = 10000 + i * 100 + j;
			buttonMatrix[i][j] = CreateWindowW(L"Button", L"", WS_VISIBLE | WS_CHILD, 30 + (j - 1) * grila / nrbuttons, 60 + (i - 1) * grila / nrbuttons, grila / nrbuttons, grila / nrbuttons, hwnd, (HMENU)x, NULL, NULL);
		}
}

void playMedium(HWND hwnd)
{
	int i, j;
	int grila = 440;
	int nrbuttons = 16;
	newGameButton = CreateWindowW(L"Button", L"Joc nou", WS_VISIBLE | WS_CHILD, (WINDOW_SIZE_WIDTH - 60) / 2, 10, 60, 30, hwnd, (HMENU)1002, NULL, NULL);
	for (i = 1; i <= nrbuttons; i++)
		for (j = 1; j <= nrbuttons; j++)
		{
			int x = 10000 + i * 100 + j;
			buttonMatrix[i][j] = CreateWindowW(L"Button", L"", WS_VISIBLE | WS_CHILD, 30 + (j - 1) * grila / nrbuttons, 60 + (i - 1) * grila / nrbuttons, grila / nrbuttons, grila / nrbuttons, hwnd, (HMENU)x, NULL, NULL);
		}
}

void playHard(HWND hwnd)
{
	int i, j;
	int grila = 440;
	int nrbuttons = 24;
	newGameButton = CreateWindowW(L"Button", L"Joc nou", WS_VISIBLE | WS_CHILD, (WINDOW_SIZE_WIDTH - 60) / 2, 10, 60, 30, hwnd, (HMENU)1003, NULL, NULL);
	for (i = 1; i <= nrbuttons; i++)
		for (j = 1; j <= nrbuttons; j++)
		{
			int x = 10000 + i * 100 + j;
			buttonMatrix[i][j] = CreateWindowW(L"Button", L"", WS_VISIBLE | WS_CHILD, 30 + (j - 1) * grila / nrbuttons, 60 + (i - 1) * grila / nrbuttons, grila / nrbuttons, grila / nrbuttons, hwnd, (HMENU)x, NULL, NULL);
		}
}

void updateGrid(HWND hwnd)
{
	int i, j;
	int grila = 440;
	bombButton = (HBITMAP)LoadImageW(NULL, L"Bomb.bmp", IMAGE_BITMAP, grila/n, grila/n, LR_LOADFROMFILE);
	for (i = 0; i < 25; i++)
		for (j = 0; j < 25; j++)
			DestroyWindow(buttonMatrix[i][j]);
	for (i = 1; i <= n; i++)
		for (j = 1; j <= n; j++)
		{
			if (a[i][j] <= 9)
			{
				int x = 10000 + i * 100 + j;
				buttonMatrix[i][j] = CreateWindowW(L"Button", L"", WS_VISIBLE | WS_CHILD, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, (HMENU)x, NULL, NULL);
			}
			else if (a[i][j] == 10)
			{
				buttonMatrix[i][j] = CreateWindowW(L"Static", L"", WS_VISIBLE | WS_CHILD, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
			}
			else if (a[i][j] <= 18)
			{
				switch (a[i][j] - 10)
				{
				case 1:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"1", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 2:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"2", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 3:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"3", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 4:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"4", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 5:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"5", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 6:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"6", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 7:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"7", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				case 8:
					buttonMatrix[i][j] = CreateWindowW(L"Static", L"8", WS_VISIBLE | WS_CHILD | SS_CENTER, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
					break;
				}
			}
			else if (a[i][j] == 19)
			{
				buttonMatrix[i][j] = CreateWindowW(L"Static", L"*", WS_VISIBLE | WS_CHILD | SS_BITMAP, 30 + (j - 1) * grila / n, 60 + (i - 1) * grila / n, grila / n, grila / n, hwnd, NULL, NULL, NULL);
				SendMessageW(buttonMatrix[i][j], STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)bombButton);
			}
		}
}

bool checkLimit(int i, int j)
{
	if (i >= 1 && i <= n && j >= 1 && j <= n)
	{
		return 1;
	}
	return 0;
}

void incrementare(int i, int j)
{
	if (a[i][j] != 9 && checkLimit(i, j))
	{
		a[i][j]++;
	}
}

void generare()
{
	srand(time(0));
	int i, j, k = 0;
	game = 1;
	switch (difficulty)
	{
	case 1:
		n = 8;
		bombs = 10;
		break;
	case 2:
		n = 16;
		bombs = 40;
		break;
	case 3:
		n = 24;
		bombs = 99;
		break;
	default:
		break;
	}
	for (i = 1; i <= n; i++)
		for (j = 1; j <= n; j++)
			a[i][j] = 0;
	while (k < bombs)
	{
		i = rand() % n + 1;
		j = rand() % n + 1;
		if (a[i][j] == 0)
		{
			a[i][j] = 9;
			k++;
		}
	}
	for (i = 1; i <= n; i++)
		for (j = 1; j <= n; j++)
		{
			if (a[i][j] == 9)
			{
				incrementare(i - 1, j - 1);
				incrementare(i - 1, j);
				incrementare(i - 1, j + 1);
				incrementare(i, j - 1);
				incrementare(i, j + 1);
				incrementare(i + 1, j - 1);
				incrementare(i + 1, j);
				incrementare(i + 1, j + 1);
			}
		}
}

void expand(int i, int j)
{
	int cnt = 0;
	if (checkLimit(i, j))
	{
		if (a[i][j] == 0)
		{
			a[i][j] = 10;
			if (checkLimit(i - 1, j - 1)) expand(i - 1, j - 1);
			if (checkLimit(i - 1, j)) expand(i - 1, j);
			if (checkLimit(i - 1, j + 1)) expand(i - 1, j + 1);
			if (checkLimit(i, j - 1)) expand(i, j - 1);
			if (checkLimit(i, j + 1)) expand(i, j + 1);
			if (checkLimit(i + 1, j - 1)) expand(i + 1, j - 1);
			if (checkLimit(i + 1, j)) expand(i + 1, j);
			if (checkLimit(i + 1, j + 1)) expand(i + 1, j + 1);
		}
		else if (a[i][j] <= 8)
		{
			a[i][j] = a[i][j] + 10;
		}
		else if (a[i][j] == 9)
		{
			a[i][j] = 19;
			game = 0;
			win = 0;
		}
		else if (a[i][j] <= 18 && a[i][j] > 10)
		{
			if (a[i - 1][j] >= 20 && checkLimit(i - 1, j)) cnt++;
			if (a[i - 1][j + 1] >= 20 && checkLimit(i - 1, j + 1)) cnt++;
			if (a[i - 1][j - 1] >= 20 && checkLimit(i - 1, j - 1)) cnt++;
			if (a[i][j - 1] >= 20 && checkLimit(i, j - 1)) cnt++;
			if (a[i][j + 1] >= 20 && checkLimit(i, j + 1)) cnt++;
			if (a[i + 1][j] >= 20 && checkLimit(i + 1, j)) cnt++;
			if (a[i + 1][j + 1] >= 20 && checkLimit(i + 1, j + 1)) cnt++;
			if (a[i + 1][j - 1] >= 20 && checkLimit(i + 1, j - 1)) cnt++;
			if (cnt == a[i][j] % 10)
			{
				if (checkLimit(i - 1, j - 1) && a[i - 1][j - 1] <= 9)
				{
					expand(i - 1, j - 1);
				}
				if (checkLimit(i - 1, j) && a[i - 1][j] <= 9)
				{
					expand(i - 1, j);
				}
				if (checkLimit(i - 1, j - 1) && a[i - 1][j + 1] <= 9)
				{
					expand(i - 1, j + 1);
				}
				if (checkLimit(i, j - 1) && a[i][j - 1] <= 9)
				{
					expand(i, j - 1);
				}
				if (checkLimit(i, j + 1) && a[i][j + 1] <= 9)
				{
					expand(i, j + 1);
				}
				if (checkLimit(i + 1, j - 1) && a[i + 1][j - 1] <= 9)
				{
					expand(i + 1, j - 1);
				}
				if (checkLimit(i + 1, j) && a[i + 1][j] <= 9)
				{
					expand(i + 1, j);
				}
				if (checkLimit(i + 1, j + 1) && a[i + 1][j + 1] <= 9)
				{
					expand(i + 1, j + 1);
				}
			}
		}
	}
}

void checkwin()
{
    int i, j;
    int cnt=0;
    for (i=1; i<=n; i++)
    {
        for (j=1; j<=n; j++)
        {
            if (a[i][j]>=10 && a[i][j]!=19)
                cnt++;
        }
    }
    if (cnt==n*n-bombs)
    {
        win=1;
        game=0;
    }
}
